/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.transport.connection.IStreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import logging.LogHolder;
import logging.LogType;

public final class SocketHandler
extends Observable {
    private IStreamConnection m_underlyingConnection;
    private SocketInputStreamImplementation m_socketInputStream;
    private SocketOutputStreamImplementation m_socketOutputStream;
    private Object m_internalSynchronization;

    public SocketHandler(IStreamConnection a_baseConnection) throws IOException {
        this.m_underlyingConnection = a_baseConnection;
        if (this.m_underlyingConnection.getCurrentState() == 2) {
            throw new IOException("Connection allready closed");
        }
        this.m_internalSynchronization = new Object();
        this.m_socketInputStream = new SocketInputStreamImplementation(this.m_underlyingConnection.getInputStream());
        this.m_socketOutputStream = new SocketOutputStreamImplementation(this.m_underlyingConnection.getOutputStream());
    }

    public void closeSocket() {
        try {
            this.m_underlyingConnection.close();
        }
        catch (IOException e) {
            LogHolder.log(3, LogType.NET, e);
        }
    }

    public InputStream getInputStream() {
        return this.m_socketInputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_socketOutputStream;
    }

    public IStreamConnection getUnderlyingIStreamConnection() {
        return this.m_underlyingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOException(IOException a_exception) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.setChanged();
            this.notifyObservers(a_exception);
        }
    }

    private void handleEndOfInputStream() {
        this.handleIOException(new IOException("SocketHandler: handleEndOfInputStream(): Unexpected end of input stream."));
    }

    private void handleInputStreamClose() {
    }

    private void handleOutputStreamClose() {
    }

    private class SocketOutputStreamImplementation
    extends OutputStream {
        private OutputStream m_underlyingStream;

        public SocketOutputStreamImplementation(OutputStream a_underlyingStream) {
            this.m_underlyingStream = a_underlyingStream;
        }

        public void write(int a_dataByte) throws IOException {
            try {
                this.m_underlyingStream.write(a_dataByte);
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
        }

        public void write(byte[] a_buffer, int a_offset, int a_length) throws IOException {
            try {
                this.m_underlyingStream.write(a_buffer, a_offset, a_length);
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
        }

        public void flush() throws IOException {
            try {
                this.m_underlyingStream.flush();
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
        }

        public void close() {
            SocketHandler.this.handleOutputStreamClose();
        }
    }

    private class SocketInputStreamImplementation
    extends InputStream {
        private InputStream m_underlyingStream;

        public SocketInputStreamImplementation(InputStream a_underlyingStream) {
            this.m_underlyingStream = a_underlyingStream;
        }

        public int read() throws IOException {
            int byteRead = -1;
            try {
                byteRead = this.m_underlyingStream.read();
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
            if (byteRead == -1) {
                SocketHandler.this.handleEndOfInputStream();
            }
            return byteRead;
        }

        public int read(byte[] a_buffer, int a_offset, int a_length) throws IOException {
            int bytesRead = -1;
            try {
                bytesRead = this.m_underlyingStream.read(a_buffer, a_offset, a_length);
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
            if (bytesRead == -1) {
                SocketHandler.this.handleEndOfInputStream();
            }
            return bytesRead;
        }

        public int available() throws IOException {
            int bytesAvailable = 0;
            try {
                bytesAvailable = this.m_underlyingStream.available();
            }
            catch (IOException e) {
                SocketHandler.this.handleIOException(e);
                throw e;
            }
            return bytesAvailable;
        }

        public void close() {
            SocketHandler.this.handleInputStreamClose();
        }
    }
}

