/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.cells;

import anon.crypto.MyAES;
import anon.tor.cells.Cell;
import anon.util.ByteArrayUtil;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class RelayCell
extends Cell {
    public static final byte RELAY_BEGIN = 1;
    public static final byte RELAY_DATA = 2;
    public static final byte RELAY_END = 3;
    public static final byte RELAY_CONNECTED = 4;
    public static final byte RELAY_SENDME = 5;
    public static final byte RELAY_EXTEND = 6;
    public static final byte RELAY_EXTENDED = 7;
    public static final byte RELAY_TRUNCATE = 8;
    public static final byte RELAY_TRUNCATED = 9;
    public static final byte RELAY_DROP = 10;
    public static final byte RELAY_RESOLVE = 11;
    public static final byte RELAY_RESOLVED = 12;
    private byte m_relayCommand;
    private Integer m_streamID;
    private boolean m_digestGenerated;

    public RelayCell() {
        super(3);
        this.m_streamID = new Integer(0);
    }

    public RelayCell(int circID) {
        super(3, circID);
        this.m_streamID = new Integer(0);
        this.m_digestGenerated = false;
    }

    public RelayCell(int circID, byte[] payload, int offset) {
        super(3, circID, payload, offset);
        this.m_relayCommand = payload[0];
        this.m_streamID = new Integer((payload[3] & 0xFF) << 8 | payload[4] & 0xFF);
        this.m_digestGenerated = false;
    }

    public RelayCell(int circID, byte relaycommand, int streamid, byte[] data) {
        super(3, circID, RelayCell.createPayload(relaycommand, streamid, data));
        this.m_relayCommand = relaycommand;
        this.m_streamID = new Integer(streamid);
        this.m_digestGenerated = false;
    }

    public byte getRelayCommand() {
        return this.m_relayCommand;
    }

    public Integer getStreamID() {
        return this.m_streamID;
    }

    public void generateDigest(SHA1Digest digest) {
        if (!this.m_digestGenerated) {
            digest.update(this.m_payload, 0, this.m_payload.length);
            SHA1Digest sha = new SHA1Digest(digest);
            byte[] d = new byte[sha.getDigestSize()];
            sha.doFinal(d, 0);
            for (int i = 0; i < 4; ++i) {
                this.m_payload[i + 5] = d[i];
            }
            this.m_digestGenerated = true;
        }
    }

    public void checkDigest(SHA1Digest digest) throws Exception {
        digest.update(this.m_payload, 0, 5);
        digest.update(new byte[4], 0, 4);
        digest.update(this.m_payload, 9, this.m_payload.length - 9);
        SHA1Digest sha = new SHA1Digest(digest);
        byte[] d = new byte[sha.getDigestSize()];
        sha.doFinal(d, 0);
        for (int i = 0; i < 4; ++i) {
            if (this.m_payload[i + 5] == d[i]) continue;
            throw new Exception("Wrong Digest detected");
        }
        this.m_digestGenerated = true;
    }

    public void doCryptography(MyAES engine) throws Exception {
        byte[] data = new byte[this.m_payload.length];
        engine.processBytesCTR(this.m_payload, 0, data, 0, 509);
        this.m_payload = data;
        this.m_relayCommand = this.m_payload[0];
        this.m_streamID = new Integer((this.m_payload[3] & 0xFF) << 8 | this.m_payload[4] & 0xFF);
    }

    private static byte[] createPayload(byte relaycommand, int streamid, byte[] data) {
        byte[] b = new byte[]{relaycommand, 0, 0};
        b = ByteArrayUtil.conc(b, ByteArrayUtil.inttobyte(streamid, 2), new byte[4]);
        if (data == null) {
            data = new byte[498];
        }
        b = data.length < 499 ? ByteArrayUtil.conc(b, ByteArrayUtil.inttobyte(data.length, 2), data) : ByteArrayUtil.conc(b, ByteArrayUtil.inttobyte(498L, 2), ByteArrayUtil.copy(data, 0, 498));
        return b;
    }

    public byte[] getCellData() {
        if (this.m_digestGenerated) {
            return super.getCellData();
        }
        return null;
    }

    public byte[] getRelayPayload() {
        int len = this.m_payload[9] & 0xFF;
        len <<= 8;
        return ByteArrayUtil.copy(this.m_payload, 11, len |= this.m_payload[10] & 0xFF);
    }
}

