/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos.messages;

import infoservice.agreement.paxos.PaxosExecution;
import infoservice.agreement.paxos.PaxosInstance;
import infoservice.agreement.paxos.PaxosRound;

public class PaxosMessage {
    public static String PROPOSE = "PROPOSE";
    public static String WEAK = "WEAK";
    public static String STRONG = "STRONG";
    public static String DECIDE = "DECIDE";
    public static String FREEZE = "FREEZE";
    public static String REJECT = "REJECT";
    public static String FREEZEPROOF = "FREEZEPROOF";
    public static String COLLECT = "COLLECT";
    private String m_messageType;
    private String m_proposal = "";
    private String m_paxosInstanceIdentifier = "";
    private String m_initiator = "";
    private String m_sender = "";
    private int m_round;

    public PaxosMessage(String a_messageType) {
        this.m_messageType = a_messageType;
    }

    public String getMessageType() {
        return this.m_messageType;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PaxosMessage)) {
            return false;
        }
        PaxosMessage other = (PaxosMessage)ob;
        boolean result = this.m_initiator.equals(other.getInitiator());
        result &= this.m_messageType.equals(other.getMessageType());
        result &= this.m_paxosInstanceIdentifier.equals(other.getPaxosInstanceIdentifier());
        result &= this.m_sender.equals(other.getSender());
        result &= this.m_proposal.equals(other.getProposal());
        return result &= this.m_round == other.getRound();
    }

    public int getRound() {
        return this.m_round;
    }

    public String getInitiator() {
        return this.m_initiator;
    }

    public String getProposal() {
        return this.m_proposal;
    }

    public String getPaxosInstanceIdentifier() {
        return this.m_paxosInstanceIdentifier;
    }

    public String getSender() {
        return this.m_sender;
    }

    public void setRound(int a_round) {
        this.m_round = a_round;
    }

    public void setInitiator(String a_initiator) {
        this.m_initiator = a_initiator;
    }

    public void setProposal(String a_proposal) {
        this.m_proposal = a_proposal;
    }

    public void setPaxosInstanceIdentifier(String a_value) {
        this.m_paxosInstanceIdentifier = a_value;
    }

    public void setSender(String a_sender) {
        this.m_sender = a_sender;
    }

    public boolean belongsTo(PaxosInstance a_instance) {
        return a_instance.getInstanceNumber().equals(this.m_paxosInstanceIdentifier);
    }

    public boolean belongsTo(PaxosExecution a_execution) {
        return a_execution.getInitiator().equals(this.m_initiator) && this.belongsTo(a_execution.getPaxosInstance());
    }

    public boolean belongsTo(PaxosRound a_round) {
        return this.belongsTo(a_round.getExecution()) && a_round.getRoundNumber() == this.m_round;
    }
}

