/*
 * Decompiled with CFR 0.152.
 */
package infoservice.performance;

import anon.crypto.SignatureVerifier;
import anon.infoservice.Database;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import infoservice.performance.PerformanceToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PerformanceRequest
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "PerformanceRequest";
    public static final String XML_ELEMENT_TOKEN_ID = "TokenId";
    public static final String XML_ELEMENT_DATASIZE = "DataSize";
    private String m_tokenId;
    private int m_dataSize;

    public PerformanceRequest(Element a_node) throws XMLParseException {
        XMLUtil.assertNodeName(a_node, XML_ELEMENT_NAME);
        if (!SignatureVerifier.getInstance().verifyXml(a_node, 2)) {
            throw new XMLParseException("Could not verify XML Document.");
        }
        Node nodeToken = XMLUtil.getFirstChildByName(a_node, XML_ELEMENT_TOKEN_ID);
        XMLUtil.assertNotNull(nodeToken);
        this.m_tokenId = XMLUtil.parseValue(nodeToken, "");
        PerformanceToken token = (PerformanceToken)Database.getInstance(PerformanceToken.class).getEntryById(this.m_tokenId);
        if (token == null) {
            throw new XMLParseException("Request did not specify a valid token.");
        }
        Node nodeDataSize = XMLUtil.getFirstChildByName(a_node, XML_ELEMENT_DATASIZE);
        XMLUtil.assertNotNull(nodeDataSize);
        this.m_dataSize = XMLUtil.parseValue(nodeDataSize, -1);
    }

    public PerformanceRequest(String a_tokenId, int a_dataSize) {
        this.m_tokenId = a_tokenId;
        this.m_dataSize = a_dataSize;
    }

    @Override
    public Element toXmlElement(Document a_doc) {
        Element elem = a_doc.createElement(XML_ELEMENT_NAME);
        Element elemTokenId = a_doc.createElement(XML_ELEMENT_TOKEN_ID);
        XMLUtil.setValue((Node)elemTokenId, this.m_tokenId);
        Element elemDataSize = a_doc.createElement(XML_ELEMENT_DATASIZE);
        XMLUtil.setValue((Node)elemDataSize, this.m_dataSize);
        elem.appendChild(elemTokenId);
        elem.appendChild(elemDataSize);
        return elem;
    }

    public String getTokenId() {
        return this.m_tokenId;
    }

    public int getDataSize() {
        return this.m_dataSize;
    }
}

