/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.perl;

import java.util.Vector;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.ParsedSubstitutionEntry;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.apache.oro.util.Cache;
import org.apache.oro.util.CacheLRU;

public final class Perl5Util
implements MatchResult {
    private static final String __matchExpression = "m?(\\W)(.*)\\1([imsx]*)";
    private PatternCache __patternCache;
    private Cache __expressionCache;
    private Perl5Matcher __matcher;
    private Pattern __matchPattern;
    private MatchResult __lastMatch;
    private Vector __splitList = new Vector();
    private Object __originalInput;
    private int __inputBeginOffset;
    private int __inputEndOffset;
    private static final String __nullString = "";
    public static final int SPLIT_ALL = 0;

    public Perl5Util(PatternCache cache) {
        this.__matcher = new Perl5Matcher();
        this.__patternCache = cache;
        this.__expressionCache = new CacheLRU(cache.capacity());
        this.__compilePatterns();
    }

    public Perl5Util() {
        this(new PatternCacheLRU());
    }

    private void __compilePatterns() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.__matchPattern = compiler.compile(__matchExpression, 16);
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Pattern __parseMatchExpression(String pattern) throws MalformedPerl5PatternException {
        Object obj = this.__expressionCache.getElement(pattern);
        try {
            if (obj != null) {
                return (Pattern)obj;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (!this.__matcher.matches(pattern, this.__matchPattern)) {
            throw new MalformedPerl5PatternException("Invalid expression: " + pattern);
        }
        MatchResult result = this.__matcher.getMatch();
        String regex = result.group(2);
        int compileOptions = 0;
        String options = result.group(3);
        if (options != null) {
            int index = options.length();
            while (index-- > 0) {
                switch (options.charAt(index)) {
                    case 'i': {
                        compileOptions |= 1;
                        break;
                    }
                    case 'm': {
                        compileOptions |= 8;
                        break;
                    }
                    case 's': {
                        compileOptions |= 0x10;
                        break;
                    }
                    case 'x': {
                        compileOptions |= 0x20;
                        break;
                    }
                    default: {
                        throw new MalformedPerl5PatternException("Invalid options: " + options);
                    }
                }
            }
        }
        Pattern ret = this.__patternCache.getPattern(regex, compileOptions);
        this.__expressionCache.addElement(pattern, ret);
        return ret;
    }

    public synchronized boolean match(String pattern, char[] input) throws MalformedPerl5PatternException {
        this.__parseMatchExpression(pattern);
        boolean result = this.__matcher.contains(input, this.__parseMatchExpression(pattern));
        if (result) {
            this.__lastMatch = this.__matcher.getMatch();
            this.__originalInput = input;
            this.__inputBeginOffset = 0;
            this.__inputEndOffset = input.length;
        }
        return result;
    }

    public synchronized boolean match(String pattern, String input) throws MalformedPerl5PatternException {
        return this.match(pattern, input.toCharArray());
    }

    public synchronized boolean match(String pattern, PatternMatcherInput input) throws MalformedPerl5PatternException {
        boolean result = this.__matcher.contains(input, this.__parseMatchExpression(pattern));
        if (result) {
            this.__lastMatch = this.__matcher.getMatch();
            this.__originalInput = input.getInput();
            this.__inputBeginOffset = input.getBeginOffset();
            this.__inputEndOffset = input.getEndOffset();
        }
        return result;
    }

    public synchronized MatchResult getMatch() {
        return this.__lastMatch;
    }

    public synchronized int substitute(StringBuffer result, String expression, String input) throws MalformedPerl5PatternException {
        char[] exp;
        block22: {
            Object obj = this.__expressionCache.getElement(expression);
            if (obj != null) {
                ParsedSubstitutionEntry entry;
                try {
                    entry = (ParsedSubstitutionEntry)obj;
                }
                catch (ClassCastException e) {
                    break block22;
                }
                int subCount = Util.substitute(result, (PatternMatcher)this.__matcher, entry._pattern, (Substitution)entry._substitution, input, entry._numSubstitutions);
                this.__lastMatch = this.__matcher.getMatch();
                return subCount;
            }
        }
        if ((exp = expression.toCharArray()).length < 4 || exp[0] != 's' || Character.isLetterOrDigit(exp[1]) || exp[1] == '-') {
            throw new MalformedPerl5PatternException("Invalid expression: " + expression);
        }
        char delimiter = exp[1];
        int firstOffset = 2;
        int thirdOffset = -1;
        int secondOffset = -1;
        boolean backslash = false;
        int index = firstOffset;
        while (index < exp.length) {
            if (exp[index] == '\\') {
                backslash = !backslash;
            } else {
                if (exp[index] == delimiter && !backslash) {
                    secondOffset = index;
                    break;
                }
                if (backslash) {
                    backslash = !backslash;
                }
            }
            ++index;
        }
        if (secondOffset == -1 || secondOffset == exp.length - 1) {
            throw new MalformedPerl5PatternException("Invalid expression: " + expression);
        }
        backslash = false;
        boolean finalDelimiter = true;
        StringBuffer replacement = new StringBuffer(exp.length - secondOffset);
        index = secondOffset + 1;
        while (index < exp.length) {
            block25: {
                block24: {
                    block23: {
                        if (exp[index] != '\\') break block23;
                        boolean bl = backslash = !backslash;
                        if (!backslash || index + 1 >= exp.length || exp[index + 1] != delimiter || expression.lastIndexOf(delimiter, exp.length - 1) == index + 1) break block24;
                        finalDelimiter = false;
                        break block25;
                    }
                    if (exp[index] == delimiter && finalDelimiter) {
                        thirdOffset = index;
                        break;
                    }
                    backslash = false;
                    finalDelimiter = true;
                }
                replacement.append(exp[index]);
            }
            ++index;
        }
        if (thirdOffset == -1) {
            throw new MalformedPerl5PatternException("Invalid expression: " + expression);
        }
        int compileOptions = 0;
        int numSubstitutions = 1;
        int numInterpolations = delimiter != '\'' ? 0 : -1;
        index = thirdOffset + 1;
        while (index < exp.length) {
            switch (exp[index]) {
                case 'i': {
                    compileOptions |= 1;
                    break;
                }
                case 'm': {
                    compileOptions |= 8;
                    break;
                }
                case 's': {
                    compileOptions |= 0x10;
                    break;
                }
                case 'x': {
                    compileOptions |= 0x20;
                    break;
                }
                case 'g': {
                    numSubstitutions = -1;
                    break;
                }
                case 'o': {
                    numInterpolations = 1;
                    break;
                }
                default: {
                    throw new MalformedPerl5PatternException("Invalid option: " + exp[index]);
                }
            }
            ++index;
        }
        Pattern compiledPattern = this.__patternCache.getPattern(new String(exp, firstOffset, secondOffset - firstOffset), compileOptions);
        Perl5Substitution substitution = new Perl5Substitution(replacement.toString(), numInterpolations);
        ParsedSubstitutionEntry entry = new ParsedSubstitutionEntry(compiledPattern, substitution, numSubstitutions);
        this.__expressionCache.addElement(expression, entry);
        int subCount = Util.substitute(result, (PatternMatcher)this.__matcher, compiledPattern, (Substitution)substitution, input, numSubstitutions);
        this.__lastMatch = this.__matcher.getMatch();
        return subCount;
    }

    public synchronized String substitute(String expression, String input) throws MalformedPerl5PatternException {
        StringBuffer result = new StringBuffer();
        this.substitute(result, expression, input);
        return result.toString();
    }

    public synchronized void split(Vector results, String pattern, String input, int limit) throws MalformedPerl5PatternException {
        MatchResult currentResult = null;
        Pattern compiledPattern = this.__parseMatchExpression(pattern);
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int beginOffset = 0;
        while (--limit != 0 && this.__matcher.contains(pinput, compiledPattern)) {
            currentResult = this.__matcher.getMatch();
            this.__splitList.addElement(input.substring(beginOffset, currentResult.beginOffset(0)));
            int groups = currentResult.groups();
            if (groups > 1) {
                int index = 1;
                while (index < groups) {
                    String group = currentResult.group(index);
                    if (group != null && group.length() > 0) {
                        this.__splitList.addElement(group);
                    }
                    ++index;
                }
            }
            beginOffset = currentResult.endOffset(0);
        }
        this.__splitList.addElement(input.substring(beginOffset, input.length()));
        while (!this.__splitList.isEmpty()) {
            String str = (String)this.__splitList.lastElement();
            if (str.length() != 0) break;
            this.__splitList.removeElementAt(this.__splitList.size() - 1);
        }
        int i = 0;
        while (i < this.__splitList.size()) {
            results.addElement(this.__splitList.elementAt(i));
            ++i;
        }
        this.__splitList.removeAllElements();
        this.__lastMatch = currentResult;
    }

    public synchronized void split(Vector results, String pattern, String input) throws MalformedPerl5PatternException {
        this.split(results, pattern, input, 0);
    }

    public synchronized void split(Vector results, String input) throws MalformedPerl5PatternException {
        this.split(results, "/\\s+/", input);
    }

    public synchronized Vector split(String pattern, String input, int limit) throws MalformedPerl5PatternException {
        Vector results = new Vector(20);
        this.split(results, pattern, input, limit);
        return results;
    }

    public synchronized Vector split(String pattern, String input) throws MalformedPerl5PatternException {
        return this.split(pattern, input, 0);
    }

    public synchronized Vector split(String input) throws MalformedPerl5PatternException {
        return this.split("/\\s+/", input);
    }

    public synchronized int length() {
        return this.__lastMatch.length();
    }

    public synchronized int groups() {
        return this.__lastMatch.groups();
    }

    public synchronized String group(int group) {
        return this.__lastMatch.group(group);
    }

    public synchronized int begin(int group) {
        return this.__lastMatch.begin(group);
    }

    public synchronized int end(int group) {
        return this.__lastMatch.end(group);
    }

    public synchronized int beginOffset(int group) {
        return this.__lastMatch.beginOffset(group);
    }

    public synchronized int endOffset(int group) {
        return this.__lastMatch.endOffset(group);
    }

    public synchronized String toString() {
        if (this.__lastMatch == null) {
            return null;
        }
        return this.__lastMatch.toString();
    }

    public synchronized String preMatch() {
        if (this.__originalInput == null) {
            return __nullString;
        }
        int begin = this.__lastMatch.beginOffset(0);
        if (begin <= 0) {
            return __nullString;
        }
        if (this.__originalInput instanceof char[]) {
            char[] input = (char[])this.__originalInput;
            if (begin > input.length) {
                begin = input.length;
            }
            return new String(input, this.__inputBeginOffset, begin);
        }
        if (this.__originalInput instanceof String) {
            String input = (String)this.__originalInput;
            if (begin > input.length()) {
                begin = input.length();
            }
            return input.substring(this.__inputBeginOffset, begin);
        }
        return __nullString;
    }

    public synchronized String postMatch() {
        if (this.__originalInput == null) {
            return __nullString;
        }
        int end = this.__lastMatch.endOffset(0);
        if (end < 0) {
            return __nullString;
        }
        if (this.__originalInput instanceof char[]) {
            char[] input = (char[])this.__originalInput;
            if (end >= input.length) {
                return __nullString;
            }
            return new String(input, end, this.__inputEndOffset - end);
        }
        if (this.__originalInput instanceof String) {
            String input = (String)this.__originalInput;
            if (end >= input.length()) {
                return __nullString;
            }
            return input.substring(end, this.__inputEndOffset);
        }
        return __nullString;
    }

    public synchronized char[] preMatchCharArray() {
        char[] result = null;
        if (this.__originalInput == null) {
            return null;
        }
        int begin = this.__lastMatch.beginOffset(0);
        if (begin <= 0) {
            return null;
        }
        if (this.__originalInput instanceof char[]) {
            char[] input = (char[])this.__originalInput;
            if (begin >= input.length) {
                begin = input.length;
            }
            result = new char[begin - this.__inputBeginOffset];
            System.arraycopy(input, this.__inputBeginOffset, result, 0, result.length);
        } else if (this.__originalInput instanceof String) {
            String input = (String)this.__originalInput;
            if (begin >= input.length()) {
                begin = input.length();
            }
            result = new char[begin - this.__inputBeginOffset];
            input.getChars(this.__inputBeginOffset, begin, result, 0);
        }
        return result;
    }

    public synchronized char[] postMatchCharArray() {
        char[] result = null;
        if (this.__originalInput == null) {
            return null;
        }
        int end = this.__lastMatch.endOffset(0);
        if (end < 0) {
            return null;
        }
        if (this.__originalInput instanceof char[]) {
            char[] input = (char[])this.__originalInput;
            if (end >= input.length) {
                return null;
            }
            int length = this.__inputEndOffset - end;
            result = new char[length];
            System.arraycopy(input, end, result, 0, length);
        } else if (this.__originalInput instanceof String) {
            String input = (String)this.__originalInput;
            if (end >= this.__inputEndOffset) {
                return null;
            }
            result = new char[this.__inputEndOffset - end];
            input.getChars(end, this.__inputEndOffset, result, 0);
        }
        return result;
    }
}

