/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp;

import anon.anonudp.exception.DecryptionFailed;
import anon.anonudp.exception.EncryptionFailed;
import anon.anonudp.mixchannel.Channel;
import anon.anonudp.mixchannel.IPv4AndPort;
import anon.anonudp.mixmessage.crypto.LinkEncryption;
import anon.anonudp.mixmessage.crypto.PublicKey;
import anon.anonudp.mixpacket.IPacket;
import anon.client.KeyExchangeManager;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.UnknownHostException;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class UDPMultiplexer {
    private DatagramSocket m_socketToMix;
    private DatagramPacket m_datagrampacketSentMixPacket;
    private final byte[] m_datagrampacketSentMixPacketData;
    private final LinkEncryption m_linkEncryption;
    private MixCascade mixCascade;
    private IPv4AndPort firstMix;
    private PublicKey[] publicKeys;
    private UDPMultiplexerReceiver receiver;

    public UDPMultiplexer(MixCascade mixCascade, KeyExchangeManager keyExchangeManager) throws Exception {
        this.mixCascade = mixCascade;
        this.setFirstMixAddress(this.mixCascade);
        this.setPublicKeys(keyExchangeManager);
        this.m_socketToMix = new DatagramSocket();
        this.m_socketToMix.connect(this.firstMix.getHost(), this.firstMix.getPort());
        this.m_datagrampacketSentMixPacketData = new byte[304];
        this.m_datagrampacketSentMixPacket = new DatagramPacket(this.m_datagrampacketSentMixPacketData, this.m_datagrampacketSentMixPacketData.length);
        this.receiver = new UDPMultiplexerReceiver(this.m_socketToMix);
        this.receiver.start();
        this.m_linkEncryption = new LinkEncryption(new byte[16]);
    }

    private void setFirstMixAddress(MixCascade cascade) throws UnknownHostException {
        String udpHost = System.getProperty("UDP_MIX_HOST", null);
        String udpPort = System.getProperty("UDP_MIX_PORT", null);
        if (udpHost != null && udpPort != null) {
            this.firstMix = new IPv4AndPort(udpHost, Integer.parseInt(udpPort));
            return;
        }
        Vector firstMixListenerInterfaces = this.mixCascade.getListenerInterfaces();
        ListenerInterface udpInterface = null;
        for (int i = 0; i < firstMixListenerInterfaces.size(); ++i) {
            if (((ListenerInterface)firstMixListenerInterfaces.get(i)).getProtocol() != 7) continue;
            udpInterface = (ListenerInterface)firstMixListenerInterfaces.get(i);
            this.firstMix = new IPv4AndPort(udpInterface.getHost(), udpInterface.getPort());
            return;
        }
        throw new RuntimeException("No suitable UDP interface found for first Mix.");
    }

    private void setPublicKeys(KeyExchangeManager keyExchangeManager) throws IOException {
        String pathPrefix = System.getProperty("UDP_MIX_KEY_PATH", "c:/temp/");
        LogHolder.log(7, LogType.NET, "Try to read UDP Mix keys from: " + pathPrefix);
        PublicKey mix1 = UDPMultiplexer.readPublicKeyFromFile(pathPrefix + "Mix1.pub");
        PublicKey mix2 = UDPMultiplexer.readPublicKeyFromFile(pathPrefix + "Mix2.pub");
        PublicKey mix3 = UDPMultiplexer.readPublicKeyFromFile(pathPrefix + "Mix3.pub");
        this.publicKeys = new PublicKey[]{mix1, mix2, mix3};
    }

    public void sendToMix(IPacket packet) throws EncryptionFailed, IOException {
        LogHolder.log(7, LogType.NET, "UDPMultiplexer - try to sent a UDP mix packet to first Mix");
        int encLen = this.m_linkEncryption.encrypt(packet, this.m_datagrampacketSentMixPacketData);
        this.m_datagrampacketSentMixPacket.setLength(encLen);
        this.m_socketToMix.send(this.m_datagrampacketSentMixPacket);
        LogHolder.log(7, LogType.NET, "UDPMultiplexer - sent a UDP mix packet to first Mix");
    }

    private void packetToChannel(IPacket mixPacket) throws DecryptionFailed {
        int channelID = mixPacket.getChannelID();
        try {
            Channel channel = (Channel)Channel.table.get(new Integer(channelID));
            channel.response(mixPacket);
        }
        catch (NullPointerException npe) {
            System.out.println("The response mix packet is for a channel not known to the multiplexer. Invalid channel id.");
        }
    }

    public PublicKey[] getPublicKeys() {
        return this.publicKeys;
    }

    private static PublicKey readPublicKeyFromFile(String path) throws IOException {
        FileInputStream binaryKey = new FileInputStream(path);
        int publicKeyLength = 29;
        byte[] keyBytes = new byte[publicKeyLength];
        binaryKey.read(keyBytes);
        binaryKey.close();
        return PublicKey.fromBytes(keyBytes);
    }

    public void stop() {
        this.receiver.stop();
        this.m_socketToMix.close();
    }

    private final class UDPMultiplexerReceiver
    implements Runnable {
        final DatagramSocket m_udpsocketFromMix;
        volatile boolean m_bRun = true;
        private Thread m_Thread;

        UDPMultiplexerReceiver(DatagramSocket socketToMix) {
            this.m_udpsocketFromMix = socketToMix;
        }

        public void start() {
            this.m_Thread = new Thread((Runnable)this, "UDPMuiltiplexer Recevier Thread");
            this.m_Thread.setDaemon(true);
            this.m_bRun = true;
            this.m_Thread.start();
        }

        public void run() {
            byte[] buffer = new byte[304];
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            while (this.m_bRun) {
                try {
                    response.setLength(buffer.length);
                    this.m_udpsocketFromMix.receive(response);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                try {
                    IPacket responseMixPacket = UDPMultiplexer.this.m_linkEncryption.decrypt(response.getData());
                    UDPMultiplexer.this.packetToChannel(responseMixPacket);
                }
                catch (DecryptionFailed decryptionFailed) {
                    decryptionFailed.printStackTrace();
                }
            }
        }

        public void stop() {
            this.m_bRun = false;
            try {
                this.m_Thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

