/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixchannel;

import anon.anonudp.exception.DecryptionFailed;
import anon.anonudp.exception.PacketCreationFailed;
import anon.anonudp.mixchannel.IPv4AndPort;
import anon.anonudp.mixmessage.Fragment;
import anon.anonudp.mixmessage.FragmentPool;
import anon.anonudp.mixmessage.Util;
import anon.anonudp.mixmessage.crypto.Counter;
import anon.anonudp.mixmessage.crypto.MyReplayDetection;
import anon.anonudp.mixmessage.crypto.PublicKey;
import anon.anonudp.mixpacket.DataPacket;
import anon.anonudp.mixpacket.IPacket;
import anon.anonudp.mixpacket.PacketFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class Channel {
    public static final int ID_SIZE = 2;
    static final int HIGHEST_ID = (int)Math.pow(2.0, 16.0) - 1;
    public static final HashMap table = new HashMap();
    private int id = Channel.randomID();
    private PacketFactory packetFactory;
    private Counter requestCounter;
    private MyReplayDetection responseReplay;
    private boolean initialized;
    private FragmentPool fragmentPool;

    public Channel(IPv4AndPort destination, PublicKey[] mixPublicKeys) throws IOException {
        this.packetFactory = new PacketFactory(this.id, destination.toBytes(), mixPublicKeys);
        this.requestCounter = new Counter();
        this.responseReplay = new MyReplayDetection();
        this.initialized = false;
        this.fragmentPool = new FragmentPool();
        table.put(new Integer(this.id), this);
    }

    public IPacket[] request(byte[] udpPayload) throws PacketCreationFailed {
        ArrayList<DataPacket> returnPackets = new ArrayList<DataPacket>();
        this.requestCounter.count();
        int fragmentNumber = 0;
        while (udpPayload != null && udpPayload.length > 0) {
            IPacket packet;
            Fragment fragment;
            if (this.initialized) {
                fragment = new Fragment(this.requestCounter.asInt(), fragmentNumber, udpPayload, 274);
                packet = this.packetFactory.makeDataPacket(fragment);
            } else {
                fragment = new Fragment(this.requestCounter.asInt(), fragmentNumber, udpPayload, 143);
                packet = this.packetFactory.makeInitPacket(fragment);
            }
            returnPackets.add((DataPacket)packet);
            udpPayload = Util.copyOfRange(udpPayload, fragment.getPayload().length, udpPayload.length);
            ++fragmentNumber;
        }
        return returnPackets.toArray(new IPacket[0]);
    }

    public void response(IPacket response) throws DecryptionFailed, IllegalArgumentException, IllegalStateException {
        if (response.getPacketType() == 3) {
            this.initialized = true;
        } else {
            if (!this.responseReplay.isValid(response.getMessageID())) {
                throw new IllegalStateException("Response Replay detected.");
            }
            DataPacket packet = (DataPacket)response;
            packet = this.packetFactory.myprocess(packet);
            Fragment fragment = new Fragment(packet.getData());
            this.fragmentPool.addFragment(fragment);
        }
    }

    private static int randomID() {
        Integer channelID;
        if (table.size() == HIGHEST_ID) {
            throw new IllegalStateException("No free channel ids available.");
        }
        Random r = new Random();
        while (table.containsKey(channelID = new Integer(r.nextInt(HIGHEST_ID + 1)))) {
        }
        return channelID;
    }

    static void _removeAllChannels() {
        table.clear();
    }

    void _setInitialized() {
        this.initialized = true;
    }

    public boolean hasNext() {
        return this.fragmentPool.hasNext();
    }

    public byte[] next() {
        return this.fragmentPool.next();
    }
}

