/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.connector;

import anon.transport.address.IAddress;
import anon.transport.address.SkypeAddress;
import anon.transport.connection.ChunkConnectionAdapter;
import anon.transport.connection.CommunicationException;
import anon.transport.connection.ConnectionException;
import anon.transport.connection.IConnection;
import anon.transport.connection.IStreamConnection;
import anon.transport.connection.SkypeConnection;
import anon.transport.connector.IConnector;
import com.skype.Application;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.Stream;
import com.skype.connector.Connector;
import logging.LogHolder;
import logging.LogType;

public class SkypeConnector
implements IConnector {
    public IStreamConnection connect(SkypeAddress a_address) throws ConnectionException {
        Application app = null;
        try {
            Connector.getInstance().setApplicationName(a_address.getApplicationName());
        }
        catch (Exception e1) {
            LogHolder.log(7, LogType.NET, "Skype Connector - exception : " + e1);
        }
        LogHolder.log(7, LogType.NET, "Skype Connector - try to get user id");
        LogHolder.log(7, LogType.TRANSPORT, "Try to register Skype forwarding application");
        try {
            app = Skype.addApplication(a_address.getApplicationName());
        }
        catch (SkypeException e) {
            throw new CommunicationException("Unable to create desired Skype Application " + a_address.getApplicationName());
        }
        if (app == null) {
            throw new CommunicationException("Unable to create desired Skype Application " + a_address.getApplicationName());
        }
        LogHolder.log(7, LogType.TRANSPORT, "Try to get a stream from Skype");
        Stream[] connectionStreams = null;
        try {
            connectionStreams = app.connect(a_address.getUserID());
        }
        catch (SkypeException e) {
            throw new CommunicationException("Unable to connect to User with ID " + a_address.getUserID());
        }
        if (connectionStreams == null || connectionStreams.length == 0) {
            throw new CommunicationException("Unable to connect to User with ID " + a_address.getUserID());
        }
        LogHolder.log(7, LogType.TRANSPORT, "Setup the base Skype connection");
        SkypeConnection baseConnection = new SkypeConnection(connectionStreams[0]);
        return new ChunkConnectionAdapter(baseConnection);
    }

    public IConnection connect(IAddress a_address) throws ConnectionException {
        if (!(a_address instanceof SkypeAddress)) {
            throw new IllegalArgumentException("Connector can only handel Address of type SkypeAddress");
        }
        return this.connect((SkypeAddress)a_address);
    }
}

