/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.IServiceContainer;
import anon.client.AbstractControlChannel;
import anon.client.Multiplexer;
import java.util.Observable;
import java.util.Observer;
import logging.LogHolder;
import logging.LogType;

public class DummyTrafficControlChannel
extends AbstractControlChannel
implements Runnable,
Observer {
    public static final int DT_MIN_INTERVAL_MS = 500;
    public static final int DT_MAX_INTERVAL_MS = 30000;
    public static final int DT_DISABLE = Integer.MAX_VALUE;
    private Observable m_observedMultiplexer;
    private volatile boolean m_bRun = false;
    private Thread m_threadRunLoop = null;
    private long m_interval = -1L;
    private Object m_internalSynchronization = new Object();

    public DummyTrafficControlChannel(Multiplexer a_multiplexer, IServiceContainer a_serviceContainer) {
        super(4, a_multiplexer, a_serviceContainer);
        this.m_observedMultiplexer = a_multiplexer;
    }

    public void run() {
        LogHolder.log(5, LogType.NET, "Dummy traffic interval: " + this.m_interval + "ms");
        while (this.m_bRun) {
            try {
                Thread.sleep(this.m_interval);
                if (!this.m_bRun) continue;
                LogHolder.log(6, LogType.NET, "Sending Dummy!");
                this.sendRawMessage(new byte[0]);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.m_bRun = false;
            this.m_observedMultiplexer.deleteObserver(this);
            if (this.m_threadRunLoop != null) {
                while (this.m_threadRunLoop.isAlive()) {
                    LogHolder.log(5, LogType.NET, "Shutting down dummy traffic channel...");
                    this.m_threadRunLoop.interrupt();
                    try {
                        this.m_threadRunLoop.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LogHolder.log(5, LogType.NET, "Dummy traffic channel closed!");
                this.m_threadRunLoop = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_observer, Object a_argument) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_threadRunLoop != null) {
                this.m_threadRunLoop.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDummyTrafficInterval(int a_interval) {
        boolean sendDummy = false;
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.stop();
            if (a_interval == Integer.MAX_VALUE) {
                LogHolder.log(4, LogType.NET, "Dummy traffic disabled!");
                return;
            }
            if (a_interval < 500) {
                a_interval = 500;
            } else if (a_interval > 30000) {
                a_interval = 30000;
            }
            this.m_interval = a_interval;
            if (a_interval > 0) {
                this.start();
                sendDummy = true;
            }
        }
        if (sendDummy) {
            LogHolder.log(7, LogType.NET, "Sending Dummy!");
            this.sendRawMessage(new byte[0]);
        }
    }

    protected void processPacketData(byte[] a_packet) {
        LogHolder.log(7, LogType.NET, "DummyTrafficControlChannel: processPacketData(): Received a dummy-packet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (!this.m_bRun) {
                this.m_bRun = true;
                this.m_threadRunLoop = new Thread((Runnable)this, "JAP - Dummy Traffic");
                this.m_threadRunLoop.setDaemon(true);
                this.m_observedMultiplexer.addObserver(this);
                this.m_threadRunLoop.start();
            }
        }
    }
}

