/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.server.TransferVolume;
import java.util.Enumeration;
import java.util.Vector;

public class ForwardSchedulerStatistics {
    private static final long BANDWIDTH_STATISTICS_INTERVAL = 1000L;
    private int m_rejectedConnections = 0;
    private int m_acceptedConnections = 0;
    private long m_transferedBytes = 0L;
    private Vector m_lastTransferVolumes = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRejectedConnections() {
        ForwardSchedulerStatistics forwardSchedulerStatistics = this;
        synchronized (forwardSchedulerStatistics) {
            ++this.m_rejectedConnections;
        }
    }

    public synchronized int getRejectedConnections() {
        int rejectedConnections = 0;
        rejectedConnections = this.m_rejectedConnections;
        return rejectedConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAcceptedConnections() {
        ForwardSchedulerStatistics forwardSchedulerStatistics = this;
        synchronized (forwardSchedulerStatistics) {
            ++this.m_acceptedConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAcceptedConnections() {
        int acceptedConnections = 0;
        ForwardSchedulerStatistics forwardSchedulerStatistics = this;
        synchronized (forwardSchedulerStatistics) {
            acceptedConnections = this.m_acceptedConnections;
        }
        return acceptedConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTransferVolume(int a_volume) {
        Object object = this.m_lastTransferVolumes;
        synchronized (object) {
            this.removeOutdatedTransferVolumes();
            this.m_lastTransferVolumes.addElement(new TransferVolume(a_volume));
        }
        object = this;
        synchronized (object) {
            this.m_transferedBytes += (long)a_volume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentBandwidthUsage() {
        int transferedBytes = 0;
        Vector vector = this.m_lastTransferVolumes;
        synchronized (vector) {
            this.removeOutdatedTransferVolumes();
            Enumeration transferVolumes = this.m_lastTransferVolumes.elements();
            while (transferVolumes.hasMoreElements()) {
                transferedBytes += ((TransferVolume)transferVolumes.nextElement()).getVolume();
            }
        }
        return Math.round((float)transferedBytes * 1000.0f / 1000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTransferedBytes() {
        long transferedBytes = 0L;
        ForwardSchedulerStatistics forwardSchedulerStatistics = this;
        synchronized (forwardSchedulerStatistics) {
            transferedBytes = this.m_transferedBytes;
        }
        return transferedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutdatedTransferVolumes() {
        Vector vector = this.m_lastTransferVolumes;
        synchronized (vector) {
            long currentTimeStamp = System.currentTimeMillis();
            boolean moreOldEntries = true;
            while (this.m_lastTransferVolumes.size() > 0 && moreOldEntries) {
                if (((TransferVolume)this.m_lastTransferVolumes.firstElement()).getTimeStamp() + 1000L < currentTimeStamp) {
                    this.m_lastTransferVolumes.removeElementAt(0);
                    continue;
                }
                moreOldEntries = false;
            }
        }
    }
}

