/*
 * Decompiled with CFR 0.152.
 */
package anon.util.captcha;

import anon.crypto.MyAES;
import anon.util.Base64;
import anon.util.ZLibTools;
import anon.util.captcha.BinaryImageExtractor;
import anon.util.captcha.IImageEncodedCaptcha;
import anon.util.captcha.MyImage;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZipBinaryImageCaptchaClient
implements IImageEncodedCaptcha {
    public static final String CAPTCHA_DATA_FORMAT = "ZIP_BINARY_IMAGE";
    private MyImage m_captchaImage;
    private int m_captchaKeyBits;
    private int m_extraKeyBits;
    private String m_characterSet;
    private int m_characterNumber;
    private byte[] m_encodedData;

    public ZipBinaryImageCaptchaClient(Element a_captchaEncodedNode) throws Exception {
        NodeList captchaDataFormatNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaDataFormat");
        if (captchaDataFormatNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure (CaptchaDataFormat node).");
        }
        Element captchaDataFormatNode = (Element)captchaDataFormatNodes.item(0);
        if (!CAPTCHA_DATA_FORMAT.equals(captchaDataFormatNode.getFirstChild().getNodeValue())) {
            throw new Exception("ZipBinaryImageCaptchaClient: Wrong captcha format.");
        }
        NodeList captchaDataNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaData");
        if (captchaDataNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (CaptchaData node).");
        }
        Element captchaDataNode = (Element)captchaDataNodes.item(0);
        byte[] compressedImageData = Base64.decode(captchaDataNode.getFirstChild().getNodeValue());
        byte[] unCompressedImageData = ZLibTools.decompress(compressedImageData);
        if (unCompressedImageData == null) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error while decompressing the captcha data.");
        }
        this.m_captchaImage = BinaryImageExtractor.binaryToImage(unCompressedImageData);
        if (this.m_captchaImage == null) {
            throw new Exception("ZipBinaryImageCaptchaClient: The image is invalid.");
        }
        NodeList cipherNodes = a_captchaEncodedNode.getElementsByTagName("DataCipher");
        if (cipherNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (DataCipher node).");
        }
        Element forwarderCipherNode = (Element)cipherNodes.item(0);
        this.m_encodedData = Base64.decode(forwarderCipherNode.getFirstChild().getNodeValue());
        NodeList captchaKeyBitsNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaKeyBits");
        if (captchaKeyBitsNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (CaptchaKeyBits node).");
        }
        Element captchaKeyBitsNode = (Element)captchaKeyBitsNodes.item(0);
        this.m_captchaKeyBits = Integer.parseInt(captchaKeyBitsNode.getFirstChild().getNodeValue());
        NodeList extraKeyBitsNodes = a_captchaEncodedNode.getElementsByTagName("ExtraKeyBits");
        if (extraKeyBitsNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (ExtraKeyBits node).");
        }
        Element extraKeyBitsNode = (Element)extraKeyBitsNodes.item(0);
        this.m_extraKeyBits = Integer.parseInt(extraKeyBitsNode.getFirstChild().getNodeValue());
        NodeList captchaCharactersNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaCharacters");
        if (captchaCharactersNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (CaptchaCharacters node).");
        }
        Element captchaCharactersNode = (Element)captchaCharactersNodes.item(0);
        this.m_characterSet = captchaCharactersNode.getFirstChild().getNodeValue();
        NodeList captchaCharacterNumberNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaCharacterNumber");
        if (captchaCharacterNumberNodes.getLength() == 0) {
            throw new Exception("ZipBinaryImageCaptchaClient: Error in XML structure. (CaptchaCharacterNumber node).");
        }
        Element captchaCharacterNumberNode = (Element)captchaCharacterNumberNodes.item(0);
        this.m_characterNumber = Integer.parseInt(captchaCharacterNumberNode.getFirstChild().getNodeValue());
    }

    public MyImage getImage() {
        return this.m_captchaImage;
    }

    public String getCharacterSet() {
        return this.m_characterSet;
    }

    public int getCharacterNumber() {
        return this.m_characterNumber;
    }

    public byte[] solveCaptcha(String a_key, byte[] a_startsWith) throws Exception {
        if (a_key.length() != this.m_characterNumber) {
            throw new Exception("ZipBinaryImageCaptchaClient: solveCaptcha: The specified key has an invalid size.");
        }
        BigInteger alphabetSize = new BigInteger(Integer.toString(this.m_characterSet.length()));
        BigInteger optimalEncoding = new BigInteger("0");
        for (int i = 0; i < this.m_characterNumber; ++i) {
            int characterPosition = this.m_characterSet.indexOf(a_key.substring(i, i + 1));
            if (characterPosition == -1) {
                throw new Exception("ZipBinaryImageCaptchaClient: solveCaptcha: The specified key contains invalid characters.");
            }
            BigInteger currentCharacter = new BigInteger(Integer.toString(characterPosition));
            optimalEncoding = optimalEncoding.multiply(alphabetSize).add(currentCharacter);
        }
        byte[] captchaKey = new byte[this.m_captchaKeyBits / 8];
        for (int i = 0; i < captchaKey.length; ++i) {
            captchaKey[i] = 0;
        }
        byte[] optimalData = optimalEncoding.toByteArray();
        int usedCaptchaKeyBits = Math.min(captchaKey.length, optimalData.length);
        System.arraycopy(optimalData, optimalData.length - usedCaptchaKeyBits, captchaKey, captchaKey.length - usedCaptchaKeyBits, usedCaptchaKeyBits);
        byte[] extraKey = null;
        int mod8ExtraKeyBits = this.m_extraKeyBits % 8;
        extraKey = mod8ExtraKeyBits == 0 ? new byte[this.m_extraKeyBits / 8] : new byte[this.m_extraKeyBits / 8 + 1];
        for (int i = 0; i < extraKey.length; ++i) {
            extraKey[i] = 0;
        }
        boolean plainDataValid = true;
        do {
            int i;
            byte[] finalKey = new byte[16];
            for (int i2 = 0; i2 < finalKey.length; ++i2) {
                finalKey[i2] = 0;
            }
            System.arraycopy(captchaKey, 0, finalKey, finalKey.length - captchaKey.length, captchaKey.length);
            System.arraycopy(extraKey, 0, finalKey, finalKey.length - captchaKey.length - extraKey.length, extraKey.length);
            MyAES aes = new MyAES();
            aes.init(false, finalKey);
            int len = this.m_encodedData.length;
            int blocks = len / 16;
            byte[] decBlock = new byte[16];
            byte[] sourceBlock = new byte[16];
            byte[] plainForwarderData = new byte[blocks * 16];
            for (i = 0; i < blocks; ++i) {
                System.arraycopy(this.m_encodedData, i * 16, sourceBlock, 0, 16);
                decBlock = aes.processBlockECB(sourceBlock);
                System.arraycopy(decBlock, 0, plainForwarderData, i * 16, 16);
            }
            plainDataValid = true;
            for (i = 0; i < a_startsWith.length; ++i) {
                if (plainForwarderData[i] == a_startsWith[i]) continue;
                plainDataValid = false;
            }
            if (!plainDataValid) {
                try {
                    extraKey = this.generateNextKey(extraKey, mod8ExtraKeyBits);
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                return plainForwarderData;
            }
        } while (!plainDataValid);
        return null;
    }

    private byte[] generateNextKey(byte[] a_currentKey, int a_mod8KeyBits) throws Exception {
        a_mod8KeyBits %= 8;
        byte[] nextKey = new byte[a_currentKey.length];
        boolean overflow = true;
        for (int i = nextKey.length - 1; i >= 0; --i) {
            byte currentByte = a_currentKey[i];
            if (overflow) {
                currentByte = (byte)(currentByte + 1);
                if (i != 0 || a_mod8KeyBits == 0) {
                    if (currentByte != 0) {
                        overflow = false;
                    }
                } else {
                    int mask = 255;
                    if ((currentByte = (byte)((mask >>>= 8 - a_mod8KeyBits) & currentByte)) != 0) {
                        overflow = false;
                    }
                }
            }
            nextKey[i] = currentByte;
        }
        if (overflow) {
            throw new Exception("ZipBinaryImageCaptchaClient: generateNextKey: No more keys available.");
        }
        return nextKey;
    }
}

