/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.crypto.Validity;
import gui.DatePanel;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ValidityContentPane
extends DialogContentPane
implements DialogContentPane.IWizardSuitable {
    private DatePanel m_dateFrom;
    private DatePanel m_dateTo;

    public ValidityContentPane(JAPDialog a_parent) {
        this(a_parent, (DialogContentPane)null);
    }

    public ValidityContentPane(JAPDialog a_parent, DialogContentPane a_previousContentPane) {
        super(a_parent, new DialogContentPane.Layout("Please choose a validity", 3), new DialogContentPaneOptions(2, a_previousContentPane));
        this.setDefaultButtonOperation(266);
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.fill = 2;
        JLabel label = new JLabel("Valid from:");
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        layout.setConstraints(label, gbc);
        this.getContentPane().add(label);
        gbc.gridx = 1;
        gbc.weightx = 5.0;
        Date now = new Date(System.currentTimeMillis());
        this.m_dateFrom = new DatePanel(now);
        layout.setConstraints(this.m_dateFrom, gbc);
        this.getContentPane().add(this.m_dateFrom);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        JButton nowButton = new JButton("Now");
        nowButton.setActionCommand("Now");
        nowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand().equals("Now")) {
                    ValidityContentPane.this.m_dateFrom.setDate(new Date(System.currentTimeMillis()));
                }
            }
        });
        layout.setConstraints(nowButton, gbc);
        this.getContentPane().add(nowButton);
        ++gbc.gridy;
        label = new JLabel("Valid to:");
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        layout.setConstraints(label, gbc);
        this.getContentPane().add(label);
        gbc.gridx = 1;
        gbc.weightx = 5.0;
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(now);
        cal2.add(1, 1);
        this.m_dateTo = new DatePanel(cal2.getTime());
        layout.setConstraints(this.m_dateTo, gbc);
        this.getContentPane().add(this.m_dateTo);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        JButton y1Button = new JButton("1 Year");
        y1Button.setActionCommand("1 Year");
        y1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand().equals("1 Year")) {
                    Calendar cal = ValidityContentPane.this.m_dateFrom.getCalendar();
                    cal.add(1, 1);
                    ValidityContentPane.this.m_dateTo.setDate(cal.getTime());
                }
            }
        });
        layout.setConstraints(y1Button, gbc);
        this.getContentPane().add(y1Button);
    }

    @Override
    public DialogContentPane.CheckError checkYesOK() {
        try {
            this.getValidity();
        }
        catch (NumberFormatException a_e) {
            return new DialogContentPane.CheckError("One or more date fields are empty");
        }
        return null;
    }

    public Validity getValidity() {
        if (-1 == this.getButtonValue() || 2 == this.getButtonValue() || this.m_dateFrom == null || this.m_dateTo == null) {
            return null;
        }
        return new Validity(this.m_dateFrom.getCalendar(), this.m_dateTo.getCalendar());
    }
}

