/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import logging.LogHolder;
import logging.LogType;

public final class ByteSignature {
    private ByteSignature() {
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair) {
        return ByteSignature.verify(byArray, byArray2, asymmetricCryptoKeyPair.getPublic());
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, IMyPublicKey iMyPublicKey) {
        if (iMyPublicKey == null) {
            LogHolder.log(7, LogType.CRYPTO, "key==null!");
            return false;
        }
        ISignatureVerificationAlgorithm iSignatureVerificationAlgorithm = iMyPublicKey.getSignatureAlgorithm();
        if (iSignatureVerificationAlgorithm == null) {
            LogHolder.log(2, LogType.CRYPTO, "Try to verify a message - unknown algorithm!");
            return false;
        }
        return iSignatureVerificationAlgorithm.verify(byArray, byArray2);
    }

    public static byte[] sign(byte[] byArray, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair) {
        return ByteSignature.sign(byArray, asymmetricCryptoKeyPair.getPrivate());
    }

    public static byte[] sign(byte[] byArray, IMyPrivateKey iMyPrivateKey) {
        if (iMyPrivateKey == null) {
            return null;
        }
        return iMyPrivateKey.getSignatureAlgorithm().sign(byArray);
    }

    public static String toHexString(byte[] byArray) {
        return ByteSignature.toHexString(byArray, ":");
    }

    public static String toHexString(byte[] byArray, String string) {
        String string2;
        String string3;
        String string4 = "";
        if (byArray == null || byArray.length == 0) {
            return string4;
        }
        if (string == null || (string3 = string.trim()).length() == 0) {
            string3 = "";
        }
        for (int i = 0; i < byArray.length; ++i) {
            string2 = Integer.toHexString(0xFF & byArray[i]).toUpperCase();
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string4 = string4 + string2;
            if (i + 1 >= byArray.length) continue;
            string4 = string4 + string3;
        }
        string2 = null;
        return string4;
    }
}

