/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MixCascadeExitAddresses
extends AbstractDatabaseEntry
implements IXMLEncodable {
    public static final int EXIT_ADDRESS_TTL = 86400000;
    public static final String XML_ELEMENT_CONTAINER_NAME = "ExitAddressesList";
    public static final String XML_ELEMENT_NAME = "ExitAddresses";
    public static final String XML_ELEMENT_ADDRESS_NAME = "ExitAddress";
    public static final String XML_ATTR_LAST_UPDATE = "lastUpdate";
    public static final String XML_ATTR_PAYMENT = "payment";
    private long m_lastUpdate;
    private String m_strCascadeId = null;
    private Hashtable m_tblAddresses = new Hashtable();
    static /* synthetic */ Class class$anon$infoservice$MixCascadeExitAddresses;
    static /* synthetic */ Class class$java$net$InetAddress;

    private MixCascadeExitAddresses(String string) {
        super(System.currentTimeMillis() + 86400000L);
        this.m_strCascadeId = string;
        this.m_lastUpdate = System.currentTimeMillis();
    }

    public MixCascadeExitAddresses(Element element) throws XMLParseException {
        super(System.currentTimeMillis() + 86400000L);
        XMLUtil.assertNodeName(element, XML_ELEMENT_NAME);
        XMLUtil.assertNotNull(element, "id");
        this.m_strCascadeId = XMLUtil.parseAttribute((Node)element, "id", null);
        this.m_lastUpdate = System.currentTimeMillis();
        NodeList nodeList = element.getElementsByTagName(XML_ELEMENT_ADDRESS_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            InetAddress inetAddress;
            long l = XMLUtil.parseAttribute(nodeList.item(i), XML_ATTR_LAST_UPDATE, System.currentTimeMillis());
            XMLUtil.assertNotNull(nodeList.item(i));
            try {
                inetAddress = InetAddress.getByName(XMLUtil.parseValue(nodeList.item(i), null));
            }
            catch (UnknownHostException unknownHostException) {
                LogHolder.log(4, LogType.NET, unknownHostException);
                continue;
            }
            this.addInetAddress(inetAddress, l);
        }
    }

    public String getId() {
        return this.m_strCascadeId;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInetAddress(String string, InetAddress inetAddress) {
        Database database = Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses);
        synchronized (database) {
            if (string != null && string.trim().length() > 0 && inetAddress != null) {
                MixCascadeExitAddresses mixCascadeExitAddresses = (MixCascadeExitAddresses)Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses).getEntryById(string);
                if (mixCascadeExitAddresses == null) {
                    mixCascadeExitAddresses = new MixCascadeExitAddresses(string);
                }
                if (mixCascadeExitAddresses.addInetAddress(inetAddress)) {
                    Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses).update(mixCascadeExitAddresses);
                }
            }
        }
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return MixCascadeExitAddresses.isValidAddress(inetAddress, "isAnyLocalAddress") || MixCascadeExitAddresses.isValidAddress(inetAddress, "isLoopbackAddress") || MixCascadeExitAddresses.isValidAddress(inetAddress, "isLinkLocalAddress") || MixCascadeExitAddresses.isValidAddress(inetAddress, "isMulticastAddress") || MixCascadeExitAddresses.isValidAddress(inetAddress, "isSiteLocalAddress");
    }

    private static boolean isValidAddress(InetAddress inetAddress, String string) {
        try {
            return (Boolean)(class$java$net$InetAddress == null ? (class$java$net$InetAddress = MixCascadeExitAddresses.class$("java.net.InetAddress")) : class$java$net$InetAddress).getMethod(string, null).invoke((Object)inetAddress, (Object[])null) == false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private boolean addInetAddress(InetAddress inetAddress) {
        return this.addInetAddress(inetAddress, System.currentTimeMillis());
    }

    private boolean addInetAddress(InetAddress inetAddress, long l) {
        boolean bl = false;
        Enumeration enumeration = this.m_tblAddresses.keys();
        while (enumeration.hasMoreElements()) {
            Long l2 = (Long)enumeration.nextElement();
            if (l2 >= System.currentTimeMillis() - 86400000L) continue;
            this.m_tblAddresses.remove(l2);
            bl = true;
        }
        if (l < System.currentTimeMillis() - 86400000L) {
            return false;
        }
        if (!this.m_tblAddresses.contains(inetAddress)) {
            this.m_tblAddresses.put(new Long(l), inetAddress);
            bl = true;
        }
        return bl;
    }

    public Element toXmlElement(Document document) {
        Element element = document.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(element, "id", this.getId());
        Enumeration enumeration = this.m_tblAddresses.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            InetAddress inetAddress = (InetAddress)this.m_tblAddresses.get(l);
            Element element2 = document.createElement(XML_ELEMENT_ADDRESS_NAME);
            XMLUtil.setAttribute(element2, XML_ATTR_LAST_UPDATE, l);
            XMLUtil.setValue((Node)element2, inetAddress.getHostAddress());
            element.appendChild(element2);
        }
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

