/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ApplicationListener;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.Stream;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Application
extends SkypeObject {
    private static final ConcurrentMap applications = new ConcurrentHashMap();
    private final String name;
    private boolean isInitialized;
    private final Object isInitializedFieldMutex = new Object();
    private Thread shutdownHookForFinish = new ShutdownHookForFinish();
    private final ConnectorListener dataListener = new DataListener();
    private final Object connectMutex = new Object();
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final Map streams = new HashMap();
    private SkypeExceptionHandler exceptionHandler;

    static Application getInstance(String id) throws SkypeException {
        Application newApplication = new Application(id);
        Application application = applications.putIfAbsent(id, newApplication);
        if (application == null) {
            application = newApplication;
        }
        application.initialize();
        return application;
    }

    private Application(String newName) throws SkypeException {
        this.name = newName;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                String response = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
                this.getAllStreams();
                if (response.startsWith("ERROR ") && !response.startsWith("ERROR 541 ")) {
                    Utils.checkError(response);
                }
                if (!this.isInitialized) {
                    Connector.getInstance().addConnectorListener(this.dataListener, false, true);
                    Runtime.getRuntime().addShutdownHook(this.shutdownHookForFinish);
                    this.isInitialized = true;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                if (this.isInitialized) {
                    Connector.getInstance().removeConnectorListener(this.dataListener);
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookForFinish);
                    String response = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                    Utils.checkError(response);
                    this.isInitialized = false;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Stream[] connect(final String id) throws SkypeException {
        Utils.checkNotNull("ids", id);
        var2_2 = this.connectMutex;
        synchronized (var2_2) {
            wait = new Object();
            connectorListener = new AbstractConnectorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void messageReceived(ConnectorMessageEvent event) {
                    String message = event.getMessage();
                    if (message.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                        Object object = wait;
                        synchronized (object) {
                            wait.notify();
                        }
                    } else if (message.startsWith("APPLICATION " + Application.this.getName() + " STREAMS ")) {
                        String streamIds = message.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                        if ("".equals(streamIds)) {
                            return;
                        }
                        String[] theids = streamIds.split(" ");
                        int i = 0;
                        while (i < theids.length) {
                            String streamId = theids[i];
                            if (streamId.startsWith(String.valueOf(id) + ":")) {
                                Object object = wait;
                                synchronized (object) {
                                    wait.notify();
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                }
            };
            try {
                Connector.getInstance().addConnectorListener(connectorListener);
                var5_6 = wait;
                synchronized (var5_6) {
                    if (id != null) {
                        command = "ALTER APPLICATION " + this.getName() + " CONNECT " + id;
                        result = Connector.getInstance().execute(command, new String[]{command, "APPLICATION " + this.getName() + " CONNECTING ", "ERROR "});
                        Utils.checkError(result);
                    }
                    try {
                        wait.wait();
                    }
                    catch (InterruptedException e) {
                        throw new SkypeException("The connecting was interrupted.", e);
                    }
                }
                var9_14 = this.getAllStreams(id);
                Connector.getInstance().removeConnectorListener(connectorListener);
            }
            catch (ConnectorException e) {
                try {
                    Utils.convertToSkypeException(e);
                    Connector.getInstance().removeConnectorListener(connectorListener);
                }
                catch (Throwable var8_15) {
                    try {
                        Connector.getInstance().removeConnectorListener(connectorListener);
                        throw var8_15;
                    }
                    catch (SkypeException e) {
                        streams = this.getAllStreams(id);
                        i = 0;
                        ** while (i < streams.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        stream = streams[i];
                        try {
                            stream.disconnect();
                        }
                        catch (SkypeException var7_13) {
                            // empty catch block
                        }
                        ++i;
                        continue;
                    }
lbl49:
                    // 1 sources

                    throw e;
                }
                return null;
            }
            return var9_14;
        }
    }

    public Stream[] getAllStreams(String id) throws SkypeException {
        ArrayList<Stream> results = new ArrayList<Stream>();
        Stream[] streams = this.getAllStreams();
        int i = 0;
        while (i < streams.length) {
            Stream stream = streams[i];
            String comparedId = stream.getFriend();
            if (comparedId.equals(id)) {
                results.add(stream);
            }
            ++i;
        }
        return results.toArray(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream[] getAllStreams() throws SkypeException {
        String streamIds = Utils.getPropertyWithCommandId("APPLICATION", this.getName(), "STREAMS");
        Map map = this.streams;
        synchronized (map) {
            this.fireStreamEvents(streamIds);
            if ("".equals(streamIds)) {
                return new Stream[0];
            }
            String[] ids = streamIds.split(" ");
            Stream[] results = new Stream[ids.length];
            int i = 0;
            while (i < ids.length) {
                results[i] = (Stream)this.streams.get(ids[i]);
                ++i;
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvents(String newStreamIdList) {
        Map map = this.streams;
        synchronized (map) {
            String[] newStreamIds = "".equals(newStreamIdList) ? new String[]{} : newStreamIdList.split(" ");
            int i = 0;
            while (i < newStreamIds.length) {
                String streamId = newStreamIds[i];
                if (!this.streams.containsKey(streamId)) {
                    Stream stream = new Stream(this, streamId);
                    this.streams.put(streamId, stream);
                    this.fireConnected(stream);
                }
                ++i;
            }
            String[] oldStreamIds = this.streams.keySet().toArray(new String[0]);
            int i2 = 0;
            while (i2 < oldStreamIds.length) {
                block8: {
                    String oldStreamId = oldStreamIds[i2];
                    int j = 0;
                    while (j < newStreamIds.length) {
                        String newStreamId = newStreamIds[j];
                        if (!oldStreamId.equals(newStreamId)) {
                            ++j;
                            continue;
                        }
                        break block8;
                    }
                    Stream stream = (Stream)this.streams.remove(oldStreamId);
                    this.fireDisconnected(stream);
                }
                ++i2;
            }
        }
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] myListeners = this.listeners.toArray(new ApplicationListener[0]);
        int i = 0;
        while (i < myListeners.length) {
            ApplicationListener listener = myListeners[i];
            try {
                listener.connected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++i;
        }
    }

    private void fireDisconnected(Stream stream) {
        ApplicationListener[] myListeners = this.listeners.toArray(new ApplicationListener[0]);
        int i = 0;
        while (i < myListeners.length) {
            ApplicationListener listener = myListeners[i];
            try {
                listener.disconnected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++i;
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    private class DataListener
    extends AbstractConnectorListener {
        private DataListener() {
        }

        public void messageReceived(ConnectorMessageEvent event) {
            String dataHeader;
            String streamsHeader;
            String message = event.getMessage();
            if (message.startsWith(streamsHeader = "APPLICATION " + Application.this.getName() + " STREAMS ")) {
                String streamIds = message.substring(streamsHeader.length());
                Application.this.fireStreamEvents(streamIds);
            }
            if (message.startsWith(dataHeader = "APPLICATION " + Application.this.getName() + " ")) {
                this.handleData(message.substring(dataHeader.length()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleData(String dataResponse) {
            block11: {
                try {
                    if (this.isReceivedText(dataResponse)) {
                        String data = dataResponse.substring("RECEIVED ".length());
                        String streamId = data.substring(0, data.indexOf(61));
                        String dataHeader = "ALTER APPLICATION " + Application.this.getName() + " READ " + streamId;
                        String response = Connector.getInstance().executeWithId(dataHeader, dataHeader);
                        Utils.checkError(response);
                        String text = response.substring(dataHeader.length() + 1);
                        Map map = Application.this.streams;
                        synchronized (map) {
                            if (Application.this.streams.containsKey(streamId)) {
                                ((Stream)Application.this.streams.get(streamId)).fireTextReceived(text);
                            }
                            break block11;
                        }
                    }
                    if (!this.isReceivedDatagram(dataResponse)) break block11;
                    String data = dataResponse.substring("DATAGRAM ".length());
                    String streamId = data.substring(0, data.indexOf(32));
                    String datagram = data.substring(data.indexOf(32) + 1);
                    Map map = Application.this.streams;
                    synchronized (map) {
                        if (Application.this.streams.containsKey(streamId)) {
                            ((Stream)Application.this.streams.get(streamId)).fireDatagramReceived(datagram);
                        }
                    }
                }
                catch (Exception e) {
                    Utils.handleUncaughtException(e, Application.this.exceptionHandler);
                }
            }
        }

        private boolean isReceivedText(String dataResponse) {
            return dataResponse.startsWith("RECEIVED ") && "RECEIVED ".length() < dataResponse.length();
        }

        private boolean isReceivedDatagram(String dataResponse) {
            return dataResponse.startsWith("DATAGRAM ");
        }
    }

    private class ShutdownHookForFinish
    extends Thread {
        private ShutdownHookForFinish() {
        }

        public void run() {
            try {
                Connector.getInstance().execute("DELETE APPLICATION " + Application.this.getName());
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
        }
    }
}

