/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlReadable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class ParentNode
extends NodeBase
implements XmlReadable {
    private NodeBase[] children;
    private int length;

    ParentNode() {
    }

    public void trimToSize() {
        if (this.length == 0) {
            this.children = null;
        } else if (this.children.length != this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
    }

    void reduceWaste() {
        if (this.children == null) {
            return;
        }
        if (this.children.length - this.length > 6) {
            this.trimToSize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        if (this.children == null) {
            return;
        }
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (this.getNodeType() == 1) {
            bl = "preserve".equals(this.getInheritedAttribute("xml:space"));
            n = xmlWriteContext.getIndentLevel();
        }
        try {
            if (!bl) {
                xmlWriteContext.setIndentLevel(n + 2);
            }
            int n2 = 0;
            while (n2 < this.length) {
                if (!bl && this.children[n2].getNodeType() != 3) {
                    xmlWriteContext.printIndent();
                    bl2 = false;
                }
                this.children[n2].writeXml(xmlWriteContext);
                ++n2;
            }
            Object var7_6 = null;
            if (bl) return;
            xmlWriteContext.setIndentLevel(n);
            if (bl2) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) throw throwable;
            xmlWriteContext.setIndentLevel(n);
            if (bl2) throw throwable;
            xmlWriteContext.printIndent();
            throw throwable;
        }
        xmlWriteContext.printIndent();
    }

    public void startParse(ParseContext parseContext) throws SAXException {
    }

    public void doneChild(NodeEx nodeEx, ParseContext parseContext) throws SAXException {
    }

    public void doneParse(ParseContext parseContext) throws SAXException {
    }

    abstract void checkChildType(int var1) throws DOMException;

    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    public final Node getFirstChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public final Node getLastChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[this.length - 1];
    }

    public final int getLength() {
        return this.length;
    }

    public final Node item(int n) {
        if (this.length == 0 || n >= this.length) {
            return null;
        }
        try {
            return this.children[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private NodeBase checkDocument(Node node) throws DOMException {
        if (node == null) {
            throw new DomEx(3);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = this.ownerDocument;
        NodeBase nodeBase = (NodeBase)node;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (document != null && document != xmlDocument) {
            throw new DomEx(4);
        }
        if (document == null) {
            nodeBase.setOwnerDocument(xmlDocument);
        }
        if (nodeBase.hasChildNodes()) {
            Node node2;
            int n = 0;
            while ((node2 = nodeBase.item(n)) != null) {
                if (node2.getOwnerDocument() == null) {
                    ((NodeBase)node2).setOwnerDocument(xmlDocument);
                } else if (node2.getOwnerDocument() != xmlDocument) {
                    throw new DomEx(4);
                }
                ++n;
            }
        }
        return nodeBase;
    }

    private void checkNotAncestor(Node node) throws DOMException {
        if (!node.hasChildNodes()) {
            return;
        }
        Node node2 = this;
        while (node2 != null) {
            if (node == node2) {
                throw new DomEx(3);
            }
            node2 = node2.getParentNode();
        }
    }

    private void mutated() {
        XmlDocument xmlDocument = this.ownerDocument;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (xmlDocument != null) {
            ++xmlDocument.mutationCount;
        }
    }

    private void consumeFragment(Node node, Node node2) throws DOMException {
        Node node3;
        ParentNode parentNode = (ParentNode)node;
        int n = 0;
        while ((node3 = parentNode.item(n)) != null) {
            this.checkNotAncestor(node3);
            this.checkChildType(node3.getNodeType());
            ++n;
        }
        while ((node3 = parentNode.item(0)) != null) {
            this.insertBefore(node3, node2);
        }
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, null);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(nodeBase.getNodeType());
        if (this.children == null) {
            this.children = new NodeBase[3];
        } else if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        nodeBase.setParentNode(this, this.length);
        this.children[this.length++] = nodeBase;
        this.mutated();
        return nodeBase;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node2 == null) {
            return this.appendChild(node);
        }
        if (this.length == 0) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        int n = 0;
        while (n < this.length) {
            if (this.children[n] == node2) {
                nodeBase.setParentNode(this, n);
                System.arraycopy(this.children, n, this.children, n + 1, this.length - n);
                this.children[n] = nodeBase;
                ++this.length;
                this.mutated();
                return node;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node == null || node2 == null) {
            throw new DomEx(3);
        }
        if (this.children == null) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return this.removeChild(node2);
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        int n = 0;
        while (n < this.length) {
            if (this.children[n] == node2) {
                nodeBase.setParentNode(this, n);
                this.children[n] = nodeBase;
                ((NodeBase)node2).setParentNode(null, -1);
                this.mutated();
                return node2;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = (NodeBase)node;
        int n = 0;
        while (n < this.length) {
            if (this.children[n] == nodeBase) {
                if (n + 1 != this.length) {
                    System.arraycopy(this.children, n + 1, this.children, n, this.length - 1 - n);
                }
                --this.length;
                this.children[this.length] = null;
                nodeBase.setParentNode(null, -1);
                this.mutated();
                return node;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public NodeList getElementsByTagName(String string) {
        if ("*".equals(string)) {
            string = null;
        }
        return new TagList(string);
    }

    public final int getIndexOf(Node node) {
        int n = 0;
        while (n < this.length) {
            if (this.children[n] == node) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    class TagList
    implements NodeList {
        private String tag;
        private int lastMutationCount;
        private int lastIndex;
        private TreeWalker lastWalker;

        private int getLastMutationCount() {
            XmlDocument xmlDocument = (XmlDocument)ParentNode.this.getOwnerDocument();
            return xmlDocument == null ? 0 : xmlDocument.mutationCount;
        }

        TagList(String string) {
            this.tag = string;
        }

        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = this.getLastMutationCount();
            if (this.lastWalker != null && (n < this.lastIndex || n2 != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = n2;
            }
            if (n == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element element = null;
            while (n > this.lastIndex && (element = this.lastWalker.getNextElement(this.tag)) != null) {
                ++this.lastIndex;
            }
            return element;
        }

        public int getLength() {
            TreeWalker treeWalker = new TreeWalker(ParentNode.this);
            Element element = null;
            int n = 0;
            while ((element = treeWalker.getNextElement(this.tag)) != null) {
                ++n;
            }
            return n;
        }
    }
}

